/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nic;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.nic.eui.ConfigurationFolderGroup;
import ibm.nways.nic.eui.NicInfoGroup;
import ibm.nways.nic.eui.SystemFolderGroup;
import ibm.nways.nic.eui.SystemGeneralFolderGroup;
import ibm.nways.ras.RAS;
import java.util.ResourceBundle;

public class AdapterJdm
extends JdmBrowser {
    private static final int RASID = 19;
    private static final int RASSUB = 25;
    NavigationFolder root;
    NavigationFolder configurationFolder;
    NavigationFolder nicSystemFolder;
    GenModel model;
    GenModel configurationFolderModel;
    GenModel systemFolderModel;
    private ResourceBundle NicBundle;
    private NavigationBrowser tree;

    public String getModelTypeName() {
        return "ibm.nways.nic.model.Adapter";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        return null;
    }

    protected NavigationPoint getNavTreeRoot() {
        this.NicBundle = ResourceBundle.getBundle("ibm.nways.nic.NicResources");
        this.displayMsg(this.NicBundle.getString("askServer"));
        this.model = (GenModel)this.getModel();
        this.displayMsg(this.NicBundle.getString("serverDone"));
        this.root = new NavigationFolder(this.NicBundle.getString("generic"));
        return this.root;
    }

    protected void getRestOfNavTree() {
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        NavigationFolder navigationFolder = (NavigationFolder)this.getNavigationTree();
        this.buildConfigurationFolder();
        this.buildSystemFolder();
        this.buildSystem();
        this.buildDmi();
        this.buildOtherApps();
        this.displayMsg(this.NicBundle.getString("initDone"));
    }

    private void buildConfigurationFolder() {
        if (this.configurationFolderModel == null) {
            try {
                this.configurationFolderModel = (GenModel)this.model.getComponent("ConfigurationFolder");
            }
            catch (Exception exception) {
                RAS.logError(19, 25, (Object)this, "buildConfigurationFolder", "EXFCEPTION_GETTING_MODELINFO");
                RAS.logException(19, 25, (Object)this, "buildConfigurationFolder", exception);
            }
        }
        this.configurationFolder = new ConfigurationFolderGroup((JdmBrowser)this, this.configurationFolderModel);
        this.configurationFolder.setIsInitiallyExpanded(true);
        this.tree.addEventListener((NavigationBrowserEventListener)((ConfigurationFolderGroup)this.configurationFolder));
        this.root.add((NavigationPoint)this.configurationFolder);
    }

    private void buildSystemFolder() {
        if (this.systemFolderModel == null) {
            try {
                this.systemFolderModel = (GenModel)this.configurationFolderModel.getComponent("SystemFolder");
            }
            catch (Exception exception) {
                RAS.logError(19, 25, (Object)this, "buildSystemFolder", "EXFCEPTION_GETTING_MODELINFO");
                RAS.logException(19, 25, (Object)this, "buildSystemFolder", exception);
            }
        }
        this.nicSystemFolder = new SystemFolderGroup((JdmBrowser)this, this.systemFolderModel);
        this.nicSystemFolder.setIsInitiallyExpanded(true);
        this.tree.addEventListener((NavigationBrowserEventListener)((SystemFolderGroup)this.nicSystemFolder));
        this.configurationFolder.add((NavigationPoint)this.nicSystemFolder);
    }

    private void buildSystem() {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("System");
            if (genModel != null) {
                SystemGeneralFolderGroup systemGeneralFolderGroup = new SystemGeneralFolderGroup((JdmBrowser)this, genModel);
                systemGeneralFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)systemGeneralFolderGroup);
                this.nicSystemFolder.add((NavigationPoint)systemGeneralFolderGroup);
                systemGeneralFolderGroup.add((NavigationPoint)new NavigationItem(this.NicBundle.getString("Identification"), new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", (RemoteModel)genModel), "SystemFolder"));
                SnmpContextModel snmpContextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
                systemGeneralFolderGroup.add((NavigationPoint)new NavigationItem(this.NicBundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", (RemoteModel)snmpContextModel), "SnmpConfig"));
                return;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 25, (Object)this, "buildSystem", exception);
        }
    }

    private void buildDmi() {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("Nic");
            if (genModel != null) {
                NicInfoGroup nicInfoGroup = new NicInfoGroup((JdmBrowser)this, genModel);
                nicInfoGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)nicInfoGroup);
                this.nicSystemFolder.add((NavigationPoint)nicInfoGroup);
                return;
            }
            if (RAS.isEnabled(19, 25)) {
                RAS.trace(19, 25, (Object)this, "buildDmi", "NIC is NULL!");
                return;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 25, (Object)this, "buildDmi", exception);
        }
    }

    private void buildOtherApps() {
        NavigationFolder navigationFolder = new NavigationFolder(this.NicBundle.getString("otherApps"));
        this.root.add((NavigationPoint)navigationFolder);
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            Browser browser = new Browser("MIB Browser", (JdmBrowser)this, snmpContextModel);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder.add((NavigationPoint)browser.getRootFolder());
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                NavigationContext navigationContext = navigationItem.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder.add((NavigationPoint)navigationItem);
                return;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 25, (Object)this, "buildOtherApps", exception);
        }
    }
}

